function [sdata,binnum] = dselect_2dhist(data,dist,center,type)
%Use a distance to select bins in a 2d histogram around a select center, it
%creates a round selection area if there is enough bins.
%Synatax:   [sdata] = dselect_2dhist(data,dist,center);
%Input:     data = the 2d data array
%           dist = the distance used to select bins
%           center = the center from which to select bins in [rows,column]
%               format
%           type = either 'circle' or 'ring'.  Total selects a circle, ring
%               selects a ring.  default = 'circle'
%Output:    sdata = selected data
%           binnum = the number of bins selected
%we are going to require all inputs for this function to work, except
%'type'.

if nargin<4
    type = 'circle';
end

y = size(data,1);   %array y size
x = size(data,2);   %array x size
xdbase = repmat(linspace(1,y,y)',1,x);    %setup the base y distance array
ydbase = repmat(linspace(1,x,x),y,1);         %setup the base x distance array
xdarray = xdbase-center(1);    %adjust for center
ydarray = ydbase-center(2);
darray = hypot(xdarray,ydarray);  %calcualte distance from center
switch type
    case 'ring'
        mask = darray<=dist+0.5&darray>dist-0.5;     %selection mask
        sdata = data.*mask;     %select data
    otherwise
        mask = darray<=dist;     %selection mask
        sdata = data.*mask;     %select data
end
binnum = sum(sum(mask));    %the number of selected bins